#!/usr/bin/perl

# create ISO-file for LibreOffice-Box
# Diese Datei wird über entsprechende Symlinks aus ~/ angesteuert,
# deren Namen für die Namen der ISO-dateien verwendet werden.

# Die Namen der Symlinks sind folgendermaßen zusammengesetzt:
# build_<LibOx-version>_<liboxzähler>_Deutsch[_snapshot]_(CD_<OS>|DVD)
# also z.B. baue_2.3.1-2_CD_Win, oder baue_2.3.1-1_snapshot_DVD

# $Id: build_iso.pl,v 1.6 2012/09/23 08:13:21 libox Exp $

use strict;
use warnings;
use File::Basename;

# Pfad zu mkisofs-programm
my $mkisofsbinary = "/home/libox/bin/mkisofs";

my $datum = `date -u --rfc-3339=date`; # for snapshots, cebit und version.txt
chomp($datum);
   $datum .= `date -u +_%H.%M.%S`; # + filename compatible time 
chomp($datum);


#fetch name from calling symlink
my $boxname = basename($0);

# alternatively from parameter
 $boxname = $ARGV[1] if $ARGV[1];

# used later
my $kommando = "$boxname";

$boxname =~  s/build_//; # reinen Namen übriglassen

my $snapshot = 1 if $boxname =~ /snapshot/i; # snapshot?
$boxname =~ s/_snapshot//i if $snapshot; # Namen bereinigen

my $cebit = 1 if $boxname =~ /cebit/i; # cebit?
$boxname =~ s/_cebit//i if $cebit; # Namen bereinigen


#bestimme Medium aus Name
my $medium;
$medium = "cd_win" if $boxname  =~  /cd_win\s*$/i; # Leerzeichen am Schluss stören nicht
#$medium = "cd_linux-deb32" if $boxname =~ /cd_linux-deb32\s*$/i; # Leerzeichen am Schluss stören nicht
#$medium = "cd_linux-deb64" if $boxname =~ /cd_linux-deb64\s*$/i; # Leerzeichen am Schluss stören nicht
#$medium = "cd_linux-rpm32" if $boxname =~ /cd_linux-rpm32\s*$/i; # Leerzeichen am Schluss stören nicht
#$medium = "cd_linux-rpm64" if $boxname =~ /cd_linux-rpm64\s*$/i; # Leerzeichen am Schluss stören nicht
$medium = "dvd" if $boxname =~ /dvd\s*$/i; # Leerzeichen am Schluss stören nicht
$medium = "cebit_dvd" if $boxname =~ /cebit_dvd\s*$/i; # Leerzeichen am Schluss stören nicht
$medium = "dvd-betrieb" if $boxname =~ /dvd-betrieb\s*$/i; # Leerzeichen am Schluss stören nicht
$medium = "cd_win-betrieb" if $boxname  =~  /cd_win-betrieb\s*$/i; # Leerzeichen am Schluss stören nicht

$boxname =~ s/(dvd).*/$1/i; # cut everything apart "DVD" from $boxname
$boxname =~ s/(cd_win).*/$1/i; # cut everything apart "CD_Win" from $boxname

#die Versionsnummer herausschneiden, da diese an das Ende kommt
my $version_nr = substr($boxname,0,5);
my $build_nr = substr($boxname,6,1);
my $build_medium = substr($boxname,7);
$boxname = $version_nr . $build_medium;


# Laufwerksbezeichnung jetzt abgreifen
my $VOLI = "LibOx-$boxname"; # Version+Medium


## Verzeichnisse bestimmen:
#  Basisverzeichnis für die Zusammenstellungen der ISO-Dateien
my $werkstattdir = "/var/www/sites/libreofficebox.org/static/de/media";

#  Basisverzeichnis für die PrOOo-Box
my $probogroupdir = "/home/libox";
   
# Aus den Daten in diesem Verzeichnis wird das ISO gebaut
my $basedir = "$werkstattdir/$medium";

# hier kommt die ISO-Datei rein
my $isodir = "$probogroupdir/download_private";

# _allplatforms, multilang und extras ergänzen bei dvd
$boxname .= "_all-platforms_multilang_extras" if $medium eq "dvd"; # Plattformbezeichnung für DVD
$boxname .= "_all-platforms_multilang_extras" if $medium eq "dvd-betrieb"; # Plattformbezeichnung für DVD-Betrieb

# multilang und extras ergänzen bei cd_win
$boxname .= "_multilang_extras" if $medium eq "cd_win";
$boxname .= "_multilang_extras" if $medium eq "cd_win-betrieb";

# snapshot-Name erzeugen
if ($snapshot) {
$snapshot = "_snapshot-$datum"; 
$boxname .= $snapshot; # Datum in Namen reinbeamen
}

# cebit-Name erzeugen
if ($cebit) {
$cebit = "_cebit-$datum"; 
$boxname .= $cebit; # Datum in Namen reinbeamen
}

# Name der ISO-Datei zusammenbauen
my $isoname = "LibOx-$boxname" . "_v$build_nr" . ".iso"; # normales ISO

# Hinweis für snapshots oder cebitvariante
my $testhinweis   = "Dies ist eine Vorabversion für Testzwecke oder Sonderausgaben.
Möglicherweise sind darin Softwarepakete enthalten, die noch
nicht entgültig für den produktiven Einsatz freigegeben sind.";


# Informationen für "version.txt" im ISO-Wurzelverzeichnis
my $build  = "Name: $isoname\n";
   $build .= "build: $datum\n" unless $snapshot || $cebit; # Buildnummer nicht bei snapshot/cbit
   $build .= "\nHinweis:\n$testhinweis\n" if $snapshot || $cebit;

# Zwischenstand
my $versioninfo = $build;

# DOS Zeilenenden verwenden
$versioninfo =~ s/\n/\r\n/g;

# Pfad zu "version.txt"
my $build_datei = "$basedir/libox_version.txt";

# Name für Versionsverwaltungsdatei 
my $build_archiv = "$probogroupdir/versions/$isoname";
   $build_archiv .= "_build-$datum" unless $snapshot || $cebit; # Buildnummer nicht bei snapshot/cbit
   $build_archiv .= ".txt";


# nur user libox kann das script ausführen wegen Quotaüberschreitung bei dvd-iso..
my $webuser = `id | grep uid=1013`;

# Alle Dateien auflisten, die $boxname enthalten, um schon
# vorhandene bei Bedarf auf einfache Weise löschen zu können ..
#my $find = qq{find $isodir $torrent_isos $torrents_dir $tracker_dir -name '*$boxname*' 2>/dev/null | grep -v baue | grep -v version | grep -v mirror};
my $find = qq{find -L $isodir -name '*$boxname*'};
my $dateien = `$find` if $webuser;
my $dateien_loeschen = $dateien;
$dateien_loeschen =~ s/\n/ /gs;
   $dateien = "\n    -- keine --\n" unless $dateien;


# Informationen zum Startmodus (mit oder ohne Torrenterstellung)
my $start = $ARGV[0];
#my $torrent_start;

# nur starten, wenn start_torrent oder start als Parameter angegeben sind
if ($start) {
   $start = 1 if $start eq "start";
   $start = undef if $start ne 1;
   }

### Meldungen ############

# nur user libox kann das script ausführen wegen Quotaüberschreitung bei dvd-iso..
unless ($webuser) {
print <<ENDE;

======================================================
  Du kannst nur als Benutzer libox ISO-dateien
  für die PrOOo-Box erzeugen!

  gebe dazu das folgende Kommando ein

sudo -i -u libox
  (dein Benutzerpasswort wird verlangt)

  danach führe den Befehl
  
$probogroupdir/isobuild/$kommando
  
  nochmal aus.

  EINE ISODATEI WURDE NICHT ERSTELLT!

ENDE
exit 0
}

# falls jemand auf die Idee kommt, diese Datei direkt aufzurufen..
if ($kommando eq "build_iso.pl") {
print <<ENDE;

======================================================
  Du hast die Datei
  "$kommando" aufgerufen. 
  Das ergibt keine brauchbaren Ergebnisse.

  wechsle in das Verzeichnis
$probogroupdir/isobuild
  und rufe einen dort vorhandenen, hierher
  zeigenden Symlink auf.
  Starte den Befehl mit einem ./ also z. B.:
./build_3.6.3-1_Deutsch_CD_Win  

  EINE ISODATEI WURDE NICHT ERSTELLT!

ENDE
exit 0
}

# Begrüßung
unless ($start) {
print <<ENDE;

======================================================
  Hallo,
  Willkommen beim Bauen von "$isoname"!

  Es existieren mit derselben Versionsbezeichnung schon folgende
  Dateien:
$dateien  
  Du bekommst am Ende des Vorgangs Informationen darüber, was 
  angelegt worden ist, damit Du reagieren kannst, falls Du es Dir
  anders überlegt hast.
  
  Zum Erstellen der ISO-Datei Befehl: start

 Für die Beschickung der ftp Mirrors brauchst Du
 besondere Rechte, oder die Hilfe von jemandem, der diese hat.

 ******* los geht's ************

 Damit es losgehen kann, gib bitte ein:

$probogroupdir/isobuild/$kommando start


  Viel Erfolg!

  EINE ISODATEI WURDE NICHT ERSTELLT!

ENDE
  exit 0
}
  

# falls aus dem Symlinknamen das zu erstellende
# medium nicht zu erkennen ist..
unless ($medium) {
print <<ENDE;

======================================================
  Es konnte nicht festgestellt werden,
  von welchen Daten die ISO-Datei erstellt
  werden soll.

  Die Namen der Symlinks sind folgendermaßen zusammengesetzt:
  build_<LibOx-version>-<liboxzähler>_Deutsch[_snapshot]_(CD_<OS>|DVD)
  also z.B. build_3.6.3-1_Deutsch_CD_Win, oder build_3.6.3-1_Deutsch_snapshot_DVD

  Falls Du dir nicht erklären kannst, was nicht stimmt, nimm einen
  vorhandenen Symlink und erstelle eine geänderte Kopie davon.


  EINE ISODATEI WURDE NICHT ERSTELLT!

ENDE
exit 0
}

# ISO existiert bereits..
if (-e "$isodir/$isoname") {
  print qq|

  Datei "$isodir/$isoname"
  existiert bereits!
  
  Bitte einen neuen Namen vergeben, oder
  die vorhandene(n) Datei(en) löschen.

  Folgende Dateien mit Versionsbezeichnung 
  
  "$boxname"
  
  wurden gefunden:
$dateien  

 
  
  Befehl, um die nicht mehr benötigten Dateien zu löschen: 
rm $dateien_loeschen 

  EINE ISODATEI WURDE NICHT ERSTELLT!

  |;
  exit 0
  }

################## Ende Meldungen #############

######### Das ISO wird aufgebaut
 
# in's webuser$HOME wechseln
chdir $probogroupdir; 

# Datei mit Versionsinformationen in's Wurzelverzeichnis des ISO schreiben
Schreibe($build_datei,$versioninfo);

# Programmversion für Isoerstellung
my $mkisofsversion = `$mkisofsbinary -version`;

# Name der Steuerdatei für mkisofs
my $isofsrc = ".mkisofsrc";

# OS-Bezeichnungen zuordnen
my $os;
$os = "Windows" if $medium =~ /cd_win/;
#$os = "Linux" if $medium =~ /cd_linux/;
$os = "Alle Plattformen" if $medium =~ /dvd/;



# erstelle Steuerdatei für mkisofs 
my $mkisofsrc =<<ENDE;
PUBL=LibreOffice-Box-Team <team\@libreofficebox.org>
PREP=LibreOffice-Box-Team <team\@libreofficebox.org>
VOLI=$VOLI
VOLS=$isoname 1/1
SYSI=$os
APPI=$mkisofsversion
ENDE

# mkisofsrc  anlegen
Schreibe($isofsrc,$mkisofsrc);

# Datei mit Positionierungsinformationen anlegen
my $posfile = "$basedir/sort_file";

my $posinfo =<<ENDE;
$basedir/bin	-6000
$basedir/start.exe	-6000
$basedir/ende.exe	-6000
$basedir/ShelExec.exe	-6000
ENDE

Schreibe($posfile, $posinfo) if $medium eq "cd_win" or "dvd";

##########
# ISOerstellung..

# in's Verzeichnis für das ISO wechseln
chdir $isodir;

# option -follow = folge symlinks - nur für CD
my $option;
#  $option = "-f" if $medium =~ /cd/;
   $option = " -sort $posfile" if (-r $posfile);

# ISO erstellen..
#system "$mkisofsbinary $option -volset-size 1 -volset-seqno 1 -rational-rock  -joliet  -disable-deep-relocation -iso-level 3 -o $isoname $basedir";
#system "$mkisofsbinary $option -volset-size 1 -volset-seqno 1 -rational-rock  -joliet-long  -disable-deep-relocation -iso-level 3 -o $isoname $basedir";
# UDF
system "$mkisofsbinary $option -volset-size 1 -volset-seqno 1 -udf -iso-level 4 -o $isoname $basedir";

# version.txt wieder löschen,
# da im dynamischen live-System ohne Sinn.
unlink $build_datei;

# md5sum erstellen..
print qq|
ermittle md5sum von $isoname ..

|;

my $md5sum_datei = "$isoname.md5sum.txt";
 system "md5sum $isoname | tee $md5sum_datei";

# weitere Informationen für's Versionsarchiv
$build .= "\nmd5sum:\n";
$build .= Lese($md5sum_datei);
$build .= "\n\nBemerkungen:\n";

# DOS Zeilenenden verwenden
$build =~ s/\n/\r\n/g;

# Schreibe Datei ins Versionsarchiv
Schreibe($build_archiv,$build);


# find nach der Erstellung aufrufen
$dateien = `$find`;
print qq|

  Alle Pfade, die "$boxname" enthalten:

$dateien

.. fertig

|;

#  Befehl, um die nicht mehr gewünschten Dateien zu löschen:
#rm "$dateien"  

 # "$inhalt" in "$datei" schreiben
sub Schreibe {
  my ($datei,$inhalt) = @_;
  open DATEI, '>', $datei or die "kann '$datei' nicht schreiben: $!\n";
  print DATEI $inhalt;
  close DATEI or die "kann '$datei' nicht schließen: $!\n";
}

 # Datei einlesen
 sub Lese {
  my $datei = shift;
# {
# local $/;
  open DATEI, '<', $datei or die "can't read '$datei': $!\n";
# }
  my @zeilen = <DATEI>;
  close DATEI or die "can't close '$datei': $!\n";
  return "@zeilen";
 }


1;

# $Log: build_iso.pl,v $
# Revision 1.6  2012/09/23 08:13:21  libox
# nochmals Altlasten entfernt
#
# Revision 1.5  2012/09/23 08:10:12  libox
# nicht mehr benötigte Kommentare (Altlasten) gelöscht
#
# Revision 1.4  2012/09/23 07:32:41  libox
# nochmals Altlasten auskommentiert bzw. entfernt
#
# Revision 1.3  2012/09/23 07:25:34  libox
# Altlasten auskommentiert
#
# Revision 1.2  2012/09/22 18:33:06  libox
# Kommentar geaendert
#
# Revision 1.1  2012/09/22 18:29:05  libox
# Initial revision
