#!/usr/bin/perl

# Hardlinks von LibreOffice Installern erstellen

# 

use strict;
use warnings;
use File::Basename;
use File::Find;
use Cwd;
use File::Path qw(make_path);

# Ziel- und Quellverzeichnisse festlegen
my @ziel_dir = ("/linux_deb/32", "/linux_deb/32/help", "/linux_deb/32/langpacks", "/linux_deb/32/libreofficebox-metapackages", "/linux_deb/64", "/linux_deb/64/help", "/linux_deb/64/langpacks", 
"/linux_deb/64/libreofficebox-metapackages", "/linux_rpm/32", "/linux_rpm/32/help", "/linux_rpm/32/langpacks", "/linux_rpm/64", "/linux_rpm/64/help", "/linux_rpm/64/langpacks", "/mac/ppc", 
"/mac/ppc/langpacks", "/mac/x86", "/mac/x86/langpacks", "/sdk/linux/deb32", "/sdk/linux/deb64", "/sdk/linux/rpm32", "/sdk/linux/rpm64", "/sdk/macosx/ppc", "/sdk/macosx/x86", 
"/sdk/windows", "/windows", "/windows/help", "/source", "/portable");

my @quell_dir = (["/deb/x86/", "_Linux_x86_deb", ".tar.gz", "/linux_deb/32/", "linux/deb32/"], ["/deb/x86_64/", "_Linux_x86-64_deb", ".tar.gz", "/linux_deb/64/", "linux/deb64/"], ["/rpm/x86/", "_Linux_x86_rpm", ".tar.gz", "/linux_rpm/32/", "linux/rpm32/"], ["/rpm/x86_64/", "_Linux_x86-64_rpm", ".tar.gz", "/linux_rpm/64/", "linux/rpm64/"], 
["/mac/ppc/", "_MacOS_PPC", ".dmg", "/mac/ppc/", "macosx/ppc/"], ["/mac/x86/", "_MacOS_x86", ".dmg", "/mac/x86/", "macosx/x86/"], ["/win/x86/", "_Win_x86", ".msi", "/windows/", "windows/"]);

my @language = ("de", "es", "fr", "it"); 
my @help = ("de", "en-US", "es", "fr", "it"); 

# aktuelles Verzeichnis herausfinden
my $work_dir = cwd;

# Verzeichnisse erstellen
foreach my $newdir (@ziel_dir) {
  make_path($work_dir.$newdir);
}

# Hardlinks erstellen

my $version = shift;
my $medium = shift;
my @dateien;
my $destdir;
my $befehl;
my $file;
my $work_file;
my $sourcedir;
my $path = "rsync://rsync.documentfoundation.org/tdf-pub/libreoffice/stable/";
my $pfad_1;
my $pfad_2;
my $source;
my $pack;
my $datname = "LibreOffice_";
my $i;

die "keine Version angegeben" unless ($version);
die "kein Medium angegeben" unless ($medium);

$source = $path . $version;
$file = "/home/libox/cms/assets/LO_installer_unpacked/" . $medium;
open FH, ">$file";
print FH "$version";
close FH;

for ($i = 0; $i <= 6; $i++) {
  $sourcedir = $source . $quell_dir[$i][0];
  print "Verzeichnis: $sourcedir \n";
  $work_file = $datname . $version . $quell_dir[$i][1] . "_sdk" . $quell_dir[$i][2];
  $pfad_1 = "/sdk/";
  $pfad_2 = $quell_dir[$i][4];
  rsync();

  $work_file = $datname . $version . $quell_dir[$i][1] . $quell_dir[$i][2];
  $pfad_1 = $quell_dir[$i][3];
  $pfad_2 = "";
  $pack = "en-US";
  rsync();

  foreach (@language) {
    $work_file = $datname . $version . $quell_dir[$i][1] . "_langpack_" . $_ . $quell_dir[$i][2];
    $pfad_2 = "langpacks/";
    $pack = $_;
    rsync();
  }

  foreach (@help) {
    $work_file = $datname . $version . $quell_dir[$i][1] . "_helppack_" . $_ . $quell_dir[$i][2];
    $pfad_2 = "help/";
    $pack = $_;
    rsync();
  }
}

sub rsync {
  print "$work_file \n";
  $destdir = $work_dir . $pfad_1 . $pfad_2;
  chdir $destdir;
  $befehl = "rsync -arv " . $sourcedir . $work_file . " " . $destdir . " >> " . $work_dir . "/rsync-ausg.txt 2>&1";
  system $befehl;
  if ($work_file =~ m/Linux/ and $work_file !~ m/sdk/) {
    $befehl = "tar -xzf " . $work_file;
    system $befehl;
    unlink $work_file;
    @dateien = <LibreOffice*>;
    rename $dateien[0], $pack;
  }
}

