#!/usr/bin/perl

# Hardlinks von LibreOffice Installern erstellen

# 

use strict;
use warnings;
use File::Basename;
use File::Find;
use Cwd;
use File::Path qw(make_path);

# Ziel- und Quellverzeichnisse festlegen
my @ziel_dir = ("/linux_deb/32", "/linux_deb/32/help", "/linux_deb/32/langpacks", "/linux_deb/32/libreofficebox-metapackages", "/linux_deb/64", "/linux_deb/64/help", "/linux_deb/64/langpacks", 
"/linux_deb/64/libreofficebox-metapackages", "/linux_rpm/32", "/linux_rpm/32/help", "/linux_rpm/32/langpacks", "/linux_rpm/64", "/linux_rpm/64/help", "/linux_rpm/64/langpacks", "/mac/ppc", 
"/mac/ppc/langpacks", "/mac/x86", "/mac/x86/langpacks", "/sdk/linux/deb32", "/sdk/linux/deb64", "/sdk/linux/rpm32", "/sdk/linux/rpm64", "/sdk/macosx/ppc", "/sdk/macosx/x86", 
"/sdk/windows", "/windows", "/windows/help", "/source", "/portable");

my @quell_dir = ("/deb/x86/", "/deb/x86_64/", "/rpm/x86/", "/rpm/x86_64/", "/mac/ppc/", "/mac/x86/", "/win/x86/");
#my @quell_dir = ("/deb/x86/");

my @language = ("de", "en-US", "es", "fr", "it"); 


# aktuelles Verzeichnis herausfinden
my $work_dir = cwd;

# Verzeichnisse erstellen
foreach my $newdir (@ziel_dir) {
  make_path($work_dir.$newdir);
}

# Hardlinks erstellen

my $version = shift;
my $medium = shift;
my @dateien;
my $destdir;
my $befehl;
my $file;
my $destfile;
my $work_file;
my $sourcedir;
my $path = "/srv/active/pub/libreoffice/stable/";
my $suchstring;
my $pfad_1;
my $pfad_2;
my $source;
my $bsys;
my $pack;
my $installer;
my $bol;
my $bol1;

die "keine Version angegeben" unless ($version);
die "kein Medium angegeben" unless ($medium);

$source = $path . $version;
$file = "/home/libox/cms/assets/LO_installer_unpacked/" . $medium;
open FH, ">$file";
print FH "$version";
close FH;

foreach (@quell_dir) {
$sourcedir = $source . $_;
print "Verzeichnis: $_ \n";
find(\&wanted,  $sourcedir);
}

sub wanted {
  $file = $File::Find::name;
  $bsys = " ";
  $pack = " ";
  $work_file = $_;
  if ($work_file =~ m/Linux_x86.*deb/) {
    $pfad_1 = "/linux_deb/32/";
    $bsys =  "Linux_x86_deb"; }
  if ($work_file =~ m/Linux_x86-64/) {
    $pfad_1 = "/linux_deb/64/";
    $bsys = "Linux_x86-64_deb"; }
  if ($work_file =~ m/Linux_x86.*rpm/) {
    $pfad_1 = "/linux_rpm/32/";
    $bsys = "Linux_x86_rpm"; }
  if ($work_file =~ m/Linux_x86-64.*rpm/) {
    $pfad_1 = "/linux_rpm/64/";
    $bsys = "Linux_x86-64_rpm"; }
  if ($work_file =~ m/MacOS_PPC.*/) {
    $pfad_1 = "/mac/ppc/";
    $bsys = "MacOS_PPC"; }
  if ($work_file =~ m/MacOS_x86.*/) {
    $pfad_1 = "/mac/x86/";
    $bsys = "MacOS_x86"; }
  if ($work_file =~ m/Win/) { 
    $pfad_1 = "/windows/";
    $bsys = "Win_x86"; }
  
  $pfad_2 = "";
  if ($work_file =~ m/sdk/) {
    $pfad_1 = "/sdk/";
    $pfad_2 = "linux/deb32/" if $work_file =~ m/Linux_x86_deb/;
    $pfad_2 = "linux/deb64/" if $work_file =~ m/Linux_x86-64_deb/;
    $pfad_2 = "linux/rpm32/" if $work_file =~ m/Linux_x86_rpm/;
    $pfad_2 = "linux/rpm64/" if $work_file =~ m/Linux_x86-64_rpm/;
    $pfad_2 = "macosx/ppc/" if $work_file =~ m/MacOS_PPC/;
    $pfad_2 = "macosx/x86/" if $work_file =~ m/MacOS_x86/;
    $pfad_2 = "windows/" if $work_file =~ m/Win/;
  }
  $bol1 ="";
  if ($work_file =~ m/helppack/) {
    $pfad_2 = "help/"; 
    $pack = "_helppack";
    $bol1 = "Y"; }
  if ($work_file =~ m/langpack/) {
    $pfad_2 = "langpacks/";
    $pack = "_langpack";
    $bol1 ="Y"; }
 
  foreach (@language) {
    # $_ enthält die aktuelle Sprache
    $bol = "";
    $suchstring = $bsys . $pack .  "_" . $_;
    $suchstring = $bsys . "_sdk"  if $work_file =~ m/sdk/ and $_ eq "de";
    $installer = "";
    $installer = "LibreOffice_" . $version . "_" . $bsys . ".tar.gz" if $bsys =~ m/Linux/;
    $installer = "LibreOffice_" . $version . "_" . $bsys . ".dmg" if $bsys =~ m/Mac/;
    $installer = "LibreOffice_" . $version . "_" . $bsys . ".msi" if $bsys =~ m/Win/;
    $bol = "Y" if $work_file eq $installer and $_ eq "en-US";
    $bol = "Y" if $work_file =~ m/$suchstring/;  
      if ($work_file !~ m/.asc/ and $bol eq "Y") {
        print "$pfad_1 $file\n";
        $destdir = $work_dir . $pfad_1 . $pfad_2;
        chdir $destdir;
        $befehl = "tar -xzf $file" if $work_file =~ m/Linux/;
        $befehl = "cp $file" . " ." if $work_file =~ m/Mac/;
        $befehl = "cp $file" . " ." if $work_file =~ m/sdk/;
        if ($work_file =~ m/Win/ and $work_file !~ m/sdk/) {
          $befehl = "cp $file" . " .";
          if ($bol1 eq "Y") {
            mkdir $_;
            chdir $_;
          }
        }
        system $befehl;
        @dateien = <LibreOffice*>;
        if ($work_file =~ m/Linux/ and $work_file !~ m/sdk/) {
          rename $dateien[0], $_;
        }
      }
    
  }
}



